******************************************************
* LED7.SRC                                           *
*                                                    *
* This program performs hexadecimal-to-7-segment     *
* conversion.  A 4-bit code is read from IP0-IP3 and *
* converted to a 7-segment code to drive a 7-segment *
* LED connected to OP0-OP6.                          *
******************************************************
DUART    EQU      $00C001     ;68681 base address
IPR      EQU      13*2        ;input port register
OPR_SET  EQU      14*2        ;set bit command reg.
OPR_CLR  EQU      15*2        ;clear bit command reg.

         ORG      $8000
LED7     MOVEA.L  #DUART,A0   ;A0 points to 68681
LOOP     MOVE.B   IPR(A0),D0  ;read input port
         ANDI.W   #$F,D0      ;clear bits 4-15
         BSR.S    CONVERT     ;convert to 7-seg code
         BSR.S    OUT681      ;update LEDs
         BRA      LOOP        ;repeat

******************************************************
* CONVERT - CONVERT a 4-bit code to a 7-segment code *
*                                                    *
*        ENTRY    D0[0:3] contains 4-bit code        *
*                 D0[4-15] cleared                   *
*        ENTRY    D0[0:6] contains 7-segment code    *
*        USES     no subroutines                     *
******************************************************
CONVERT  MOVE.B   TABLE(PC,D0.W),D0 ;table look-up
         RTS
TABLE    DC.B     $01,$4F,$12,$06   ;7-segment LED
         DC.B     $4C,$24,$20,$0F   ;  patterns
         DC.B     $00,$0C,$08,$60
         DC.B     $31,$42,$30,$38

******************************************************
* OUT681 - OUTput data to 68681 output port          *
*                                                    *
*        ENTER:   D0[0:7] contains data to output    *
*                 A0 points to 68681 DUART           *
*        EXIT:    all registers intact               *
*        USES:    no subroutines                     *
******************************************************
OUT681   MOVE.B   D0,OPR_CLR(A0) ;clr. bits, set pins
         NOT.B    D0
         MOVE.B   D0,OPR_SET(A0) ;set bits, clr. pins
         NOT.B    D0             ;restore D0
         RTS
         END      LED7
